'
' Started....14/12/21
' Microcontroller used:  Microchip Technology PIC16F1455
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------
' 
''When switched on level crossing open, signal green and relay is in RUN position
'On interupt level crossing open, signal red and relay in STOP position
'1 sec delay relay in RUN, signal green and level crossing closed. ADC inputs determine time delays
#CONFIG
        __config _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
        __config _CONFIG2, _FCMEN_OFF & _PLLEN_DISABLED & _LVP_ON
#ENDCONFIG
                                                                      
  
 on interrupt goto increase
 
 OSCCON = %00110110   '4mhz int osc
 OSCTUNE = %00000000

 define ADC_BITS 10
 
 define  ADC_SAMPLEUS 50
 
 
OPTION_REG = %11000000 ' PORT A&B Pull-Ups disabled, interrupt rising edge RC1 
INTCON     = %10010000 ' External interrupts on RC1


ADCON0   =   %00010000 ' A/D Module is on,ch4 RC0
ADCON1   =   %11010000' right justified ADC ref VDD fosc/16


DACCON0.7 = 0  'DAC off
FVRCON.0 = 0 'Voltage ref off
T1CON.0 = 0 'timer 1 off
CM1CON0    = %00000000 ' Comparator1 Module is OFF
CM2CON0    = %00000000 ' Comparator2 Module is OFF
UCON.3 = 0  'USB off 
SSPCON1.5 = 0 'disable serial ports
TRISA      = %00011000 ' all outputs except RA3 master reset and RA4 (AN4) input for RV3
ANSELA     = %00010000 'all digital except RA4 analogue for reading pot RV4
WPUA       = %00000000 'weak pull ups disabled

TRISC      = %00000111 ' all outputs except RC0 analogue input1 for ADC AN4 RC2, analogue input2 for ADC AN6 RC2 and RC1 interrupt                                                                                             
ANSELC     = %00000101 ' all digital except RC0 which is analogue for reading pot and RC2 the analogue input for pot 2
 '------------Variables-------------

a var word '10 bit result on AN4
b var word '10 bit result on AN2
d var word '10 bit result on AN3
Y var Word '10 times a
Z var word '10 times b
X var word '10 times d
c var byte 'interrupt count
'----------Initialization----------

 PORTC.4 = 0' level crossing open 
 PORTC.3 = 0' Relay unenergised (Train running)
 PORTC.5 = 0' Signal arm down (green)
 PORTA.5 = 0  ' whistle off
  a = 0
  b = 0
  d = 0
  X = 0
  Y = 0
  Z = 0
  c = 0
 
'-------------Main Code------------

   Start:
   
   If c = 0 then goto initialise
   if c = 1 then goto routine
   initialise:
   PORTC.4 = 0' level crossing open 
   PORTC.3 = 0' Relay unenergised (Train running)
   PORTC.5 = 0' Signal arm down (green)
   PORTA.5 = 0  ' whistle off
   hold:
   if c = 0  then goto hold
   if c = 1 then goto routine
   routine:
   ADCON0 = %00010000'set ADC to read CH4 RCO
   pause 1 
   ADCIN 4 ,a 'measure CH4 pot voltage and store in a
   pause 1 
   ADCON0 = %00011000 'set ADC to read CH6 RC2
   pause 1
   adcin 6 ,b ' measure CH6 pot voltage and store in b
   pause 1
   ADCON0 = %00001100 'set ADC to read CH3
   pause 1
   adcin 3 ,d' measure CH3 pot and store in d
   pause 1
   Y = a *10 'seconds X 10 pot 1
   Z = b * 10 'seconds  X 10 pot 2
   X = d * 10
   PORTC.4 = 0 ' Level crossing open
   PORTC.5 = 1 'Signal up (red)
   PORTC.3 = 1  'Relay energised (brake)
   Pause Y
   PORTC.5 = 0 'signal green
   pause X
   PORTC.3 = 0 'train runs
   PORTC.4 = 1 'crossing closed
   pause 4000
   PORTA.5 = 1  ' whistle sounds
   pause 200
   PORTA.5 = 0  ' whistle off
   
   pause Z 'pause no of seconds set by pot 2 before level crossing closes
   PORTC.4 = 0 ' level crossing open
   c = 0
   goto hold
  
   
   disable 
   increase: 
   c = c + 1
   'if c > 1 then c = 0
   pause 100
   INTCON.1 = 0 'clear interrupt flag
   RESUME ' go back 
   enable 
   
   
  
 


